(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      7346,        242]*)
(*NotebookOutlinePosition[      8188,        269]*)
(*  CellTagsIndexPosition[      8144,        265]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \( (*\ Example\ 8.4  .3 . \[IndentingNewLine]4 - 
        point\ trapezoidal\ rule, \ m = \(4 = j\), \ 
      q = 1; \[IndentingNewLine]x0 = \(0 = s0\), \ x1 = \(1/3 = s0\), \ 
      x2 = \(2/3 = s2\), \ 
      x3 = \(1 = s3\); \[IndentingNewLine]Use\ formula\ 8  a  .2  .4, \ 
      to\ compute\ D = \ {v0, v1, v2, 
          v3}; \[IndentingNewLine]\[Kappa] \((xi, sj)\) = \(\(|\)\(xi - 
            sj\)\(|\)\(\(\(^\)\((1/2)\)\)\ log\)\(|\)\(xi - 
            sj\)\(|\)\), \ \[IndentingNewLine]i, j = 0, 1, 2, 
      3\ *) \)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(h = 1/3;\)\), "\[IndentingNewLine]", 
    \(v0 = Sqrt[h]*Integrate[Sqrt[1 - t], {t, 0, 1}]\)}], "Input"],

Cell[BoxData[
    \(2\/\(3\ \@3\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(v1 = Sqrt[h]*Integrate[1/Sqrt[1 - t], {t, 0, 1}]\)], "Input"],

Cell[BoxData[
    \(2\/\@3\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(v2 = v1\)], "Input"],

Cell[BoxData[
    \(2\/\@3\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(v3 = v1\)], "Input"],

Cell[BoxData[
    \(2\/\@3\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(d = {{2/\((3  Sqrt[3])\), 0, 0, 0}, {0, 2/Sqrt[3], 0, 0}, {0, 0, 
          2/Sqrt[3], 0}, {0, 0, 0, 2/Sqrt[3]}}\)], "Input"],

Cell[BoxData[
    \({{2\/\(3\ \@3\), 0, 0, 0}, {0, 2\/\@3, 0, 0}, {0, 0, 2\/\@3, 0}, {0, 0, 
        0, 2\/\@3}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(x = Table[{0, 1/3, \ 2/3, 1}]\)], "Input"],

Cell[BoxData[
    \({0, 1\/3, 2\/3, 1}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(s = Table[{0, 1/3, 2/3, 1}]\)], "Input"],

Cell[BoxData[
    \({0, 1\/3, 2\/3, 1}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(k[x_, s_] := \ 
        Abs[x - s]*Log[Abs[x - s]];\)\), "\[IndentingNewLine]", 
    \(Table[k[x[\([i]\)], s[\([j]\)]], {i, 4}, \ {j, 4}]\ \)}], "Input"],

Cell[BoxData[
    \({{Indeterminate, \(-\(Log[3]\/3\)\), \(-\(2\/3\)\)\ Log[3\/2], 
        0}, {\(-\(Log[3]\/3\)\), 
        Indeterminate, \(-\(Log[3]\/3\)\), \(-\(2\/3\)\)\ Log[
            3\/2]}, {\(-\(2\/3\)\)\ Log[3\/2], \(-\(Log[3]\/3\)\), 
        Indeterminate, \(-\(Log[3]\/3\)\)}, {0, \(-\(2\/3\)\)\ Log[
            3\/2], \(-\(Log[3]\/3\)\), Indeterminate}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(matkappa = {{0, \(-\(Log[3]\/3\)\), \(-\(2\/3\)\)\ Log[3\/2], 
          0}, {\(-\(Log[3]\/3\)\), 
          0, \(-\(Log[3]\/3\)\), \(-\(2\/3\)\)\ Log[
              3\/2]}, {\(-\(2\/3\)\)\ Log[3\/2], \(-\(Log[3]\/3\)\), 
          0, \(-\(Log[3]\/3\)\)}, {0, \(-\(2\/3\)\)\ Log[
              3\/2], \(-\(Log[3]\/3\)\), 0}}\)], "Input"],

Cell[BoxData[
    \({{0, \(-\(Log[3]\/3\)\), \(-\(2\/3\)\)\ Log[3\/2], 
        0}, {\(-\(Log[3]\/3\)\), 
        0, \(-\(Log[3]\/3\)\), \(-\(2\/3\)\)\ Log[3\/2]}, {\(-\(2\/3\)\)\ Log[
            3\/2], \(-\(Log[3]\/3\)\), 
        0, \(-\(Log[3]\/3\)\)}, {0, \(-\(2\/3\)\)\ Log[
            3\/2], \(-\(Log[3]\/3\)\), 0}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(a = matkappa\  . \ d\)], "Input"],

Cell[BoxData[
    \({{0, \(-\(\(2\ Log[3]\)\/\(3\ \@3\)\)\), \(-\(\(4\ Log[
                  3\/2]\)\/\(3\ \@3\)\)\), 
        0}, {\(-\(\(2\ Log[3]\)\/\(9\ \@3\)\)\), 
        0, \(-\(\(2\ Log[3]\)\/\(3\ \@3\)\)\), \(-\(\(4\ Log[
                  3\/2]\)\/\(3\ \@3\)\)\)}, {\(-\(\(4\ Log[
                  3\/2]\)\/\(9\ \@3\)\)\), \(-\(\(2\ Log[
                  3]\)\/\(3\ \@3\)\)\), 
        0, \(-\(\(2\ Log[3]\)\/\(3\ \@3\)\)\)}, {0, \(-\(\(4\ Log[
                  3\/2]\)\/\(3\ \@3\)\)\), \(-\(\(2\ Log[
                  3]\)\/\(3\ \@3\)\)\), 0}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(f[x_] := \ 
        x - \((x^2\ Log[x] + \((1 - x^2)\)\ Log[1 - x] - x - 1/2)\)/
            2;\)\), "\[IndentingNewLine]", 
    \(Table[f[x[\([i]\)]], \ {i, 4}]\)}], "Input"],

Cell[BoxData[
    \({Indeterminate, 1\/3 + 1\/2\ \((5\/6 + 8\/9\ Log[3\/2] + Log[3]\/9)\), 
      2\/3 + 1\/2\ \((7\/6 + 4\/9\ Log[3\/2] + \(5\ Log[3]\)\/9)\), 
      Indeterminate}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(b = {0, 1\/3 + 1\/2\ \((5\/6 + 8\/9\ Log[3\/2] + Log[3]\/9)\), 
        2\/3 + 1\/2\ \((7\/6 + 4\/9\ Log[3\/2] + \(5\ Log[3]\)\/9)\), 
        0}\)], "Input"],

Cell[BoxData[
    \({0, 1\/3 + 1\/2\ \((5\/6 + 8\/9\ Log[3\/2] + Log[3]\/9)\), 
      2\/3 + 1\/2\ \((7\/6 + 4\/9\ Log[3\/2] + \(5\ Log[3]\)\/9)\), 
      0}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(LinearSolve[a, b]\)], "Input"],

Cell[BoxData[
    \({\((\(-90\)\ \@3\ Log[3\/2] - 16\ \@3\ Log[3\/2]\^2 + 27\ \@3\ Log[3] - 
            4\ \@3\ Log[3\/2]\ Log[3] + 
            2\ \@3\ Log[3]\^2)\)/\((8\ \((4\ Log[3\/2]\^2 - Log[3]\^2)\))\), 
      0, 0, \((\(-54\)\ \@3\ Log[3\/2] - 32\ \@3\ Log[3\/2]\^2 + 
            45\ \@3\ Log[3] + 4\ \@3\ Log[3\/2]\ Log[3] + 
            10\ \@3\ Log[3]\^2)\)/\((24\ \((4\ Log[3\/2]\^2 - 
                Log[3]\^2)\))\)}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(N[%]\)], "Input"],

Cell[BoxData[
    \({3.4791565094088988`, 0.`, 0.`, \(-4.746894677814554`\)}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \( (*\ Exact\ solution\ *) \[IndentingNewLine]\(\[Phi][x_] := \ 
        x;\)\), "\[IndentingNewLine]", 
    \(Table[\[Phi][x[\([i]\)]], \ {i, 4}] // N\)}], "Input"],

Cell[BoxData[
    \({0.`, 0.3333333333333333`, 0.6666666666666666`, 1.`}\)], "Output"]
}, Open  ]]
},
FrontEndVersion->"4.0 for Macintosh",
ScreenRectangle->{{0, 832}, {0, 604}},
WindowSize->{520, 482},
WindowMargins->{{1, Automatic}, {Automatic, 1}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1717, 49, 557, 10, 107, "Input"],

Cell[CellGroupData[{
Cell[2299, 63, 127, 2, 43, "Input"],
Cell[2429, 67, 47, 1, 46, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2513, 73, 81, 1, 27, "Input"],
Cell[2597, 76, 40, 1, 46, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2674, 82, 40, 1, 27, "Input"],
Cell[2717, 85, 40, 1, 46, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2794, 91, 40, 1, 27, "Input"],
Cell[2837, 94, 40, 1, 46, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2914, 100, 145, 2, 43, "Input"],
Cell[3062, 104, 126, 2, 85, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3225, 111, 62, 1, 27, "Input"],
Cell[3290, 114, 52, 1, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3379, 120, 60, 1, 27, "Input"],
Cell[3442, 123, 52, 1, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3531, 129, 176, 3, 43, "Input"],
Cell[3710, 134, 385, 6, 144, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4132, 145, 357, 6, 144, "Input"],
Cell[4492, 153, 337, 6, 144, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4866, 164, 53, 1, 27, "Input"],
Cell[4922, 167, 573, 10, 201, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5532, 182, 198, 4, 43, "Input"],
Cell[5733, 188, 195, 3, 76, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5965, 196, 178, 3, 76, "Input"],
Cell[6146, 201, 171, 3, 76, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6354, 209, 50, 1, 27, "Input"],
Cell[6407, 212, 446, 7, 221, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6890, 224, 37, 1, 27, "Input"],
Cell[6930, 227, 90, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7057, 233, 184, 3, 59, "Input"],
Cell[7244, 238, 86, 1, 26, "Output"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

